Copyright Michael Abrash, 1988.  All Rights Reserved.
;
; Program to demonstrate the 4 text pages of the CGA.
;
; To demonstrate the 8 standard text pages of the VGA/EGA,
; change NUMBER_OF_PAGES from 4 to 8.
;
; To demonstrate the 16 text pages available on the VGA/EGA
; when display memory is relocated to A000, change NUMBER_OF_PAGES
; to 16 and change RELOCATE_TO_A000 from 0 to 1.
;
; To demonstrate that the upper 8 text pages can be displayed even
; when the CPU can't access them, change NUMBER_OF_PAGES to 16,
; RELOCATE_TO_A000 to 1, and RELOCATE_BACK_TO_B800 to 1.
;
; By Michael Abrash  5/22/88
;

NUMBER_OF_PAGES		equ	4
RELOCATE_TO_A000	equ	0
RELOCATE_BACK_TO_B800	equ	0
PAGE_LENGTH		equ	1000h	;number of bytes per page

if RELOCATE_TO_A000
DISPLAY_MEMORY_SEGMENT	equ	0a000h
else
DISPLAY_MEMORY_SEGMENT	equ	0b800h
endif

GC_INDEX		equ	3ceh
GC_MISCELLANEOUS	equ	6
CRTC_INDEX		equ	3d4h
CRTC_START_ADDRESS_HIGH	equ	0ch
CRTC_START_ADDRESS_LOW	equ	0dh

stack	segment	para stack 'STACK'
	db	512 dup (?)
stack	ends

code	segment para public 'CODE'
	assume	cs:code, ds:nothing
start	proc	near
;
; Set to text mode.
;
	mov	ax,3
	int	10h
;
; Relocate display memory to A000 if necessary, by reprogramming
; the Graphics Controller's Miscellaneous register.
;
if RELOCATE_TO_A000
	mov	dx,GC_INDEX
	mov	al,GC_MISCELLANEOUS
	out	dx,al
	inc	dx
	mov	al,06h
	out	dx,al
endif
;
; Point to the segment that display memory is currently
; addressed at.
;
	mov	ax,DISPLAY_MEMORY_SEGMENT
	mov	es,ax
;
; Fill each of the text screens in turn with an appropriate character.
; (Page 0 is filled with "A", page 1 with "B", and so on.)
;
	sub	ax,ax	;start with page 0
	mov	bl,'A'	;base letter
FillPageLoop:
	push	ax
	call	FillPage
	pop	ax
	inc	ax
	cmp	ax,NUMBER_OF_PAGES
	jb	FillPageLoop
;
; Relocate display memory back to B800 if necessary,
; by reprogramming the Graphics Controller's Miscellaneous
; register, to illustrate the principle that it's possible to
; display the upper 8 pages even when the CPU can't access them.
;
if RELOCATE_BACK_TO_B800
	mov	dx,GC_INDEX
	mov	al,GC_MISCELLANEOUS
	out	dx,al
	inc	dx
	mov	al,0Eh
	out	dx,al
endif
;
; Display each of the text pages in turn, waiting for a key
; before going to the next page.
;
	sub	ax,ax
ShowPageLoop:
	push	ax
	call	ShowPage
	call	WaitKey
	pop	ax
	inc	ax
	cmp	ax,NUMBER_OF_PAGES
	jb	ShowPageLoop
;
; Done-perform a mode set to reset all paging and clear
; the screen, then return to DOS.
;
	mov	ax,3
	int	10h
	mov	ah,4ch
	int	21h
start	endp
;
; Fills a text page with a corresponding character.
;
; Input:
;	AX = text page
;	BL = character for text page 0 (each text page
;		is filled with character BL + text page #)
;
FillPage	proc	near
	push	ax	;save the page #
	mov	dx,PAGE_LENGTH
	mul	dx	;calculate the start offset of the page
			; in the display memory segment
	mov	di,ax
	pop	ax	;get back the page #
	add	al,bl	;convert it to a unique letter
	mov	ah,7	;attribute is white
	mov	cx,PAGE_LENGTH/2 ;page length as measured
				 ; in character/attribute pairs
	cld
	rep	stosw	;fill the page
	ret
FillPage	endp
;
; Programs the CRTC to display the desired text page.
;
; Input: AX = text page.
;
ShowPage	proc	near
	mov	dx,PAGE_LENGTH/2
	mul	dx		;start offset of the pages as
				; measured in character/attribute
				; pairs (which is how the CRTC
				; counts in text mode)
	mov	dx,CRTC_INDEX	;point to the CRTC Index register
	push	ax
	mov	al,CRTC_START_ADDRESS_HIGH
	out	dx,al
	inc	dx		;point to the CRTC Data register
	mov	al,ah
	out	dx,al		;set the high start address byte
	dec	dx		;point to the CRTC Index register
	mov	al,CRTC_START_ADDRESS_LOW
	out	dx,al
	inc	dx		;point to the CRTC Data register
	pop	ax
	out	dx,al		;set the low start address byte
	ret
ShowPage	endp
;
; Waits until a key is pressed.
;
WaitKey	proc	near
	mov	ah,1
	int	16h
	jz	WaitKey
	sub	ah,ah
	int	16h	;clear the key
	ret
WaitKey	endp

code	ends
	end	start

